#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Variations on Overlapping BoxesMod01.fsh   by   R3N 
//https://www.shadertoy.com/view/7tlXR8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define saturate(t) clamp(t, 0.0, 1.0)
#define pi acos(-1.0)

float rand(vec2 p) {
	return fract(sin(dot(p, vec2(12.543,514.123)))*4732.12);
}

vec3 col(in float t) {
    return 0.5+0.5*cos(2.0*pi*(t+vec3(0, 0.1, 0.2)) );
}

float box(vec2 p, vec2 r) {
	vec2 d = abs(p) - r;
	return length(max(d, 0.0)) + min(max(d.x, d.y), 0.0);
}

float bBox(vec2 p, vec2 r) {
	float bp = box(p, r)-0.025;
	return 0.2*saturate(smoothstep(0.01, 0.005, abs(bp))+0.5*smoothstep(0.01, 0.005, bp));
}

mat2 rot(float a) {
    return mat2(cos(a), -sin(a), sin(a), cos(a));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = fragCoord/iResolution.y;
    vec2 hs = iResolution.xy/iResolution.y*0.5;
	vec2 uvc = uv-hs;
	uvc *= rot(-acos(-1.0)/3.0);
	uvc *= 0.5;
	float r = 0.0;
	for(float i = 0.0; i < 30.0; i++) {
		vec2 uvs = uvc;
		uvs += vec2(4, 1)*rand(vec2(i*13.0));
		vec2 sz = vec2(rand(vec2(i)), rand(vec2(-i*7.0)));
		sz = sz.y > sz.x ? sz.yx : sz.xy;
		sz.x = max(sz.x, 0.3);
		uvs.x += fract(-iTime*mix(0.075, 0.001, sz.y));
		sz *= vec2(0.3, 0.2);
		uvs = fract(uvs)-0.5;
		r += bBox(uvs, sz);
	}
    float cn = (3.0+mod(floor(iTime*0.5),5.0));
	fragColor = vec4(col(cn*r), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

